<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeacherTable extends Migration {

	public function up()
	{
		Schema::create('teacher', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('lesson_id');
			$table->string('name', 255);
			$table->tinyInteger('public');
			$table->string('position');
			$table->text('short_desc');
			$table->string('photo');
			$table->string('permissions');
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('teacher');
	}
}