<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormsTable extends Migration {

	public function up()
	{
		Schema::create('forms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('name');
			$table->string('visibility');
			$table->boolean('allows_edit');
			$table->string('identifier')->nullable();
			$table->text('form_builder_json')->nullable();
			$table->text('analytics');
			$table->text('custom_url');
			$table->text('emailresponse');
		});
	}

	public function down()
	{
		Schema::drop('forms');
	}
}