<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminRolePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('admin_role_permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('role_id')->unsigned()->index();
			$table->integer('route_id')->unsigned()->index();
			$table->tinyInteger('permission')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admin_role_permissions');
	}
}