<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Rating extends Eloquent {

	protected $table = 'ratings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('rating');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function interpreter()
	{
		return $this->belongsTo('App\Models\User');
	}

}