<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerCardsTable extends Migration {

	public function up()
	{
		Schema::create('customer_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->string('card_name');
			$table->bigInteger('card_number');
			$table->text('car_validity');
			$table->string('card_type');
			$table->smallInteger('card_cvv')->unsigned();
			$table->bigInteger('customer_id')->unsigned();
			$table->tinyInteger('default_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customer_cards');
	}
}