<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_owner')->unsigned();
			$table->bigInteger('order_delivery')->unsigned();
			$table->text('order_name');
			$table->string('order_id', 13);
			$table->string('order_description');
			$table->smallInteger('order_price');
			$table->tinyInteger('order_active')->default('0');
			$table->string('order_status');
			$table->timestamps();
			$table->string('order_payment_type');
			$table->tinyInteger('order_payment_status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}