<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTestpressoTable extends Migration {

	public function up()
	{
		Schema::create('testpresso', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('question', 256);
			$table->integer('weightage')->default('1');
			$table->text('answer_key');
			$table->string('reference', 256)->nullable();
			$table->integer('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('testpresso');
	}
}