<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormRowsTable extends Migration {

	public function up()
	{
		Schema::create('form_rows', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('control_form_id');
			$table->smallInteger('major_number')->nullable();
			$table->smallInteger('minor_number')->nullable();
			$table->smallInteger('diminutive_number');
			$table->boolean('multiple_per_heading')->default(0);
			$table->integer('sort_order')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('form_rows');
	}
}