<?php

namespace Rockit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $hidden = array('password');

    public function group()
    {
        return $this->belongsTo('Group');
    }

    public function language()
    {
        return $this->belongsTo('Language');
    }

}