<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCalculatorApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('calculator_applications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('calculator_id')->unsigned()->nullable();
			$table->string('type');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('pdf_file_name')->nullable();
			$table->integer('pdf_file_size')->unsigned();
			$table->string('pdf_content_type')->nullable();
			$table->timestamp('pdf_updated_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('calculator_applications');
	}
}