<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCalculatorCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('calculator_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('calculator_id')->unsigned();
			$table->string('image_file_name')->nullable();
			$table->integer('image_file_size')->nullable();
			$table->string('image_content_type')->nullable();
			$table->timestamp('image_updated_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('calculator_categories');
	}
}