<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_features', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_subscriptions', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('agents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('plan_subscriptions', function(Blueprint $table) {
			$table->foreign('plan_is')->references('id')->on('plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_currency_id_foreign');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->dropForeign('plans_currency_id_foreign');
		});
		Schema::table('plan_features', function(Blueprint $table) {
			$table->dropForeign('plan_features_plan_id_foreign');
		});
		Schema::table('plan_subscriptions', function(Blueprint $table) {
			$table->dropForeign('plan_subscriptions_agent_id_foreign');
		});
		Schema::table('plan_subscriptions', function(Blueprint $table) {
			$table->dropForeign('plan_subscriptions_plan_is_foreign');
		});
	}
}