<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgentsTable extends Migration {

	public function up()
	{
		Schema::create('agents', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('currency_id')->unsigned();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->unique();
			$table->string('avatar')->nullable();
			$table->bigInteger('phone');
			$table->string('address');
			$table->date('birthdate');
			$table->string('status');
			$table->string('civil_id');
			$table->string('lastlogin');
			$table->timestamps();
			$table->text('national_id_image');
			$table->string('verified_at');
			$table->string('language_key');
			$table->string('area_id');
			$table->string('remember_token');
		});
	}

	public function down()
	{
		Schema::drop('agents');
	}
}