<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCurrenciesTable extends Migration {

	public function up()
	{
		Schema::create('currencies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->tinyInteger('code');
			$table->string('symbol');
			$table->string('format');
			$table->string('exchange_rate');
			$table->tinyInteger('is_active')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('currencies');
	}
}