<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessTable extends Migration {

	public function up()
	{
		Schema::create('business', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->integer('business_category_id')->unsigned();
			$table->string('location', 255);
			$table->string('phone', 255);
			$table->string('attachment', 255);
			$table->integer('user_id')->unsigned();
			$table->date('open_at');
			$table->date('close_st');
			$table->integer('max_people');
			$table->string('fees', 255);
		});
	}

	public function down()
	{
		Schema::drop('business');
	}
}