<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('villes', function(Blueprint $table) {
			$table->foreign('pays_id')->references('id')->on('pays')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('auteurs', function(Blueprint $table) {
			$table->foreign('ville_id')->references('id')->on('villes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('livres', function(Blueprint $table) {
			$table->foreign('theme_id')->references('id')->on('themes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->foreign('auteur_id')->references('id')->on('auteurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->foreign('livre_id')->references('id')->on('livres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('themables', function(Blueprint $table) {
			$table->foreign('theme_id')->references('id')->on('themes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('editeur_id')->references('id')->on('editeurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('villes', function(Blueprint $table) {
			$table->dropForeign('villes_pays_id_foreign');
		});
		Schema::table('auteurs', function(Blueprint $table) {
			$table->dropForeign('auteurs_ville_id_foreign');
		});
		Schema::table('livres', function(Blueprint $table) {
			$table->dropForeign('livres_theme_id_foreign');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->dropForeign('auteur_livre_auteur_id_foreign');
		});
		Schema::table('auteur_livre', function(Blueprint $table) {
			$table->dropForeign('auteur_livre_livre_id_foreign');
		});
		Schema::table('themables', function(Blueprint $table) {
			$table->dropForeign('themables_theme_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_editeur_id_foreign');
		});
	}
}