<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLedgerTable extends Migration {

	public function up()
	{
		Schema::create('ledger', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('account_number')->unsigned();
			$table->softDeletes();
			$table->double('debit', 12,4);
			$table->double('credit', 12,2);
			$table->double('balance', 12,2);
			$table->text('remarks');
			$table->text('hash')->nullable()->index();
			$table->string('type', 20);
		});
	}

	public function down()
	{
		Schema::drop('ledger');
	}
}