<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 64)->index();
			$table->string('password', 128)->index();
			$table->enum('profile_type', array('Account', 'Teller', 'Admin'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}