<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ledger', function(Blueprint $table) {
			$table->foreign('account_number')->references('account_number')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('parent_account')->references('account_number')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('account_number')->references('account_number')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bio_signatures', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->foreign('account_number')->references('account_number')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('account_number')->references('account_number')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bio_photos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tellers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tellers', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ledger', function(Blueprint $table) {
			$table->dropForeign('ledger_account_number_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_user_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_parent_account_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_branch_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_account_number_foreign');
		});
		Schema::table('bio_signatures', function(Blueprint $table) {
			$table->dropForeign('bio_signatures_user_id_foreign');
		});
		Schema::table('requirements', function(Blueprint $table) {
			$table->dropForeign('requirements_account_number_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_account_number_foreign');
		});
		Schema::table('bio_photos', function(Blueprint $table) {
			$table->dropForeign('bio_photos_user_id_foreign');
		});
		Schema::table('tellers', function(Blueprint $table) {
			$table->dropForeign('tellers_user_id_foreign');
		});
		Schema::table('tellers', function(Blueprint $table) {
			$table->dropForeign('tellers_branch_id_foreign');
		});
	}
}