<?php

class Accounts extends Eloquent {

	protected $table = 'accounts';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function ledgers()
	{
		return $this->hasMany('\Ledger', 'account_number');
	}

	public function addresses()
	{
		return $this->hasMany('Addresses', 'account_number');
	}

	public function requirements()
	{
		return $this->hasMany('Requirements', 'account_number');
	}

	public function branch()
	{
		return $this->hasOne('Branches', 'branch_id');
	}

	public function transactions()
	{
		return $this->hasMany('Transactions', 'account_number');
	}

}