<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id');
			$table->decimal('total');
			$table->string('promocode', 100);
			$table->string('discount', 100);
			$table->string('address', 255);
			$table->string('lat', 100);
			$table->string('lon', 100);
			$table->enum('status', array('processing', 'delivered', 'canceled'));
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}