<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Damaged extends Model 
{

    protected $table = 'damaged';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'country_id', 'mall_id', 'supply_id', 'quantity');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function supply()
    {
        return $this->belongsTo('Supply', 'supply_id');
    }

}