<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->foreign('create_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tournaments', function(Blueprint $table) {
			$table->foreign('promoter')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('matchs', function(Blueprint $table) {
			$table->foreign('first_team')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matchs', function(Blueprint $table) {
			$table->foreign('second_team')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('matchs', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tournament_competitors', function(Blueprint $table) {
			$table->foreign('tournament_id')->references('id')->on('tournaments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tournament_competitors', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_team_id_foreign');
		});
		Schema::table('teams', function(Blueprint $table) {
			$table->dropForeign('teams_create_by_foreign');
		});
		Schema::table('tournaments', function(Blueprint $table) {
			$table->dropForeign('tournaments_promoter_foreign');
		});
		Schema::table('matchs', function(Blueprint $table) {
			$table->dropForeign('matchs_first_team_foreign');
		});
		Schema::table('matchs', function(Blueprint $table) {
			$table->dropForeign('matchs_second_team_foreign');
		});
		Schema::table('matchs', function(Blueprint $table) {
			$table->dropForeign('matchs_tournament_id_foreign');
		});
		Schema::table('tournament_competitors', function(Blueprint $table) {
			$table->dropForeign('tournament_competitors_tournament_id_foreign');
		});
		Schema::table('tournament_competitors', function(Blueprint $table) {
			$table->dropForeign('tournament_competitors_team_id_foreign');
		});
	}
}