<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->string('logo');
			$table->string('name', 100)->unique()->nullable();
			$table->integer('create_by')->unsigned();
			$table->integer('number_of_footballers')->unsigned()->default('1');
			$table->integer('tournament_points')->unsigned()->default('0');
			$table->integer('played_matches')->unsigned()->default('0');
			$table->integer('completed_tournaments')->unsigned()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}