<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('author_id')->unsigned();
			$table->integer('category_id')->unsigned()->nullable();
			$table->string('title', 255);
			$table->string('seo_title', 255)->nullable();
			$table->text('excerpt')->nullable();
			$table->text('body');
			$table->string('image', 255);
			$table->string('slug', 255)->unique();
			$table->text('meta_description')->nullable();
			$table->text('meta_keywords');
			$table->enum('status', array(''));
			$table->tinyInteger('featured')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}