<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('number', 255);
			$table->string('mail_id', 255);
			$table->string('password');
			$table->string('longitude', 255);
			$table->string('latitude', 255);
			$table->enum('status_flag', array('1', '0'));
			$table->string('otp', 255);
			$table->datetime('otp_time');
			$table->enum('isVerified', array('1', '0'));
			$table->timestamps();
			$table->timestamp('updated_at');
			$table->string('language_json', 255);
			$table->string('signup_type', 255);
			$table->string('provider_name', 255);
			$table->string('provider_id', 255);
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}