<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('event_type_id')->unsigned()->index();
			$table->string('user_name')->nullable();
			$table->json('data')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}