<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserGroup extends Model 
{

    protected $table = 'user_groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_section()
    {
        return $this->belongsTo('UserSection');
    }

    public function users()
    {
        return $this->morphMany('User', 'usable');
    }

}