<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePegSectionsTable extends Migration {

	public function up()
	{
		Schema::create('peg_sections', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id');
			$table->string('number');
			$table->string('title');
			$table->string('body')->nullable();
			$table->integer('lft');
			$table->integer('rgt');
			$table->integer('depth');
			$table->enum('type', array(''simple'', ''competence''));
			$table->string('color_hex', 6);
			$table->json('components');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('peg_sections');
	}
}