<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFiltersTable extends Migration {

	public function up()
	{
		Schema::create('filters', function(Blueprint $table) {
			$table->string('name', 80);
			$table->enum('type', array('title', 'details'));
			$table->increments('id');
			$table->bigInteger('filter_recurring_id')->unsigned();
			$table->bigInteger('category_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('filters');
	}
}