<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'view_id', 'image', 'text1', 'text2', 'parent_id', 'is_all', 'category_recurring_id');

	public function view()
	{
		return $this->belongsTo('App\Models\View');
	}

	public function categoryRecurring()
	{
		return $this->belongsTo('App\Models\CategoryRecurring', 'category_recurring_id');
	}

	public function filters()
	{
		return $this->hasMany('App\Models\Filter');
	}

	public function subAccounts()
	{
		return $this->belongsToMany('App\Models\SubAccount');
	}

	public function parents()
	{
		return $this->belongsTo('App\Models\Category', 'parent_id', 'id');
	}

	public function childs()
	{
		return $this->hasMany('App\Models\Category', 'parent_id', 'id');
	}

}