<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CategoryRecurring extends Eloquent {

	protected $table = 'categories_recurring';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description', 'view_id', 'image', 'text1', 'text2');

	public function categories()
	{
		return $this->hasMany('App\Models\Category', 'category_recurring_id');
	}

	public function view()
	{
		return $this->belongsTo('App\Models\View', 'view_id');
	}

}