<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubAccount extends Eloquent {

	protected $table = 'sub_accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'account_id');

	public function account()
	{
		return $this->belongsTo('App\Models\Account');
	}

	public function filters()
	{
		return $this->belongsToMany('App\Models\Filter');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category');
	}

	public function firltersRecurring()
	{
		return $this->belongsToMany('App\Models\FilterRecurring', 'filter_recurring_sub_accounts');
	}

}