<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubFilterRecurring extends Eloquent {

	protected $table = 'sub_filters_recurring';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'filter_recurring_id');

	public function filtersRecurring()
	{
		return $this->belongsTo('App\Models\FilterRecurring', 'filter_recurring_id');
	}

	public function subFilters()
	{
		return $this->hasMany('App\Models\SubFilter', 'recurring_sub_filter_id');
	}

}