<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class View extends Eloquent {

	protected $table = 'views';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'image');

	public function category()
	{
		return $this->hasMany('App\Models\Category');
	}

	public function categoriesRecurring()
	{
		return $this->hasMany('App\Models\CategoryRecurring', 'view_id');
	}

}