<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProveedoresContactosTable extends Migration {

	public function up()
	{
		Schema::create('proveedores_contactos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_proveedor')->index();
			$table->integer('id_tipo_contacto')->unsigned()->index();
			$table->tinyInteger('principal');
			$table->string('nombre');
			$table->string('telefono');
			$table->string('telefono2')->nullable();
			$table->string('email');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('proveedores_contactos');
	}
}