<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProveedoresTable extends Migration {

	public function up()
	{
		Schema::create('proveedores', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre')->index();
			$table->string('nombre_fiscal');
			$table->string('cif')->nullable();
			$table->string('producto_principal', 512)->nullable();
			$table->decimal('descuento')->nullable();
			$table->decimal('margen');
			$table->integer('id_metodo_pedido')->unsigned();
			$table->integer('id_forma_pago')->nullable();
			$table->integer('plazo_pago')->nullable();
			$table->integer('cuenta_contable')->nullable();
			$table->string('web')->nullable();
			$table->string('web_user')->nullable();
			$table->string('web_pass')->nullable();
			$table->string('comentarios', 512)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('proveedores');
	}
}