<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientesTable extends Migration {

	public function up()
	{
		Schema::create('clientes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_centro')->nullable();
			$table->integer('id_padre')->nullable();
			$table->integer('id_forma_pago')->nullable();
			$table->string('plazo_de_pago')->nullable();
			$table->string('nombre')->nullable();
			$table->string('cif')->nullable();
			$table->tinyInteger('presupuesto_con_iva');
			$table->tinyInteger('exento_iva');
			$table->tinyInteger('recargo_equivalencia');
			$table->string('cuenta_iva')->nullable();
			$table->string('cuenta_de_pago', 512)->nullable();
			$table->string('cuenta_contable');
			$table->timestamps();
			$table->softDeletes();
			$table->string('intracomunitario');
		});
	}

	public function down()
	{
		Schema::drop('clientes');
	}
}