<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactosClientesTable extends Migration {

	public function up()
	{
		Schema::create('contactos_clientes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_clientes')->index();
			$table->tinyInteger('principal');
			$table->string('nombre');
			$table->integer('id_tipo_contacto')->unsigned()->index();
			$table->string('telefono2')->nullable();
			$table->string('telefono');
			$table->string('email');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contactos_clientes');
	}
}