<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationsRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donations_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('patient_name');
			$table->integer('patient_age');
			$table->string('patient_phone');
			$table->integer('city_id')->unsigned();
			$table->string('hospital_address');
			$table->string('hospital_name');
			$table->integer('blood_type_id')->unsigned();
			$table->integer('bugs_num');
			$table->string('details');
			$table->decimal('latitude', 10,8);
			$table->decimal('longitude');
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('donations_requests');
	}
}