<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('category_variant_template', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_variant_template', function(Blueprint $table) {
			$table->foreign('variant_template_id')->references('id')->on('variant_templates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('variant_name_id')->references('id')->on('variant_names')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variant_values', function(Blueprint $table) {
			$table->foreign('product_variant_id')->references('id')->on('product_variants')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variant_values', function(Blueprint $table) {
			$table->foreign('variant_value_id')->references('id')->on('variant_values')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('skus', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variant_value_sku', function(Blueprint $table) {
			$table->foreign('product_variant_value_id')->references('id')->on('product_variant_values')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variant_value_sku', function(Blueprint $table) {
			$table->foreign('sku_id')->references('id')->on('skus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('location_sku', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('location_sku', function(Blueprint $table) {
			$table->foreign('sku_id')->references('id')->on('skus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sku_images', function(Blueprint $table) {
			$table->foreign('sku_id')->references('id')->on('skus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute_template_category', function(Blueprint $table) {
			$table->foreign('attribute_template_id')->references('id')->on('attribute_templates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attribute_template_category', function(Blueprint $table) {
			$table->foreign('product_type_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('sku_id')->references('id')->on('skus')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('product_attributes', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_brand_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('category_variant_template', function(Blueprint $table) {
			$table->dropForeign('category_variant_template_category_id_foreign');
		});
		Schema::table('category_variant_template', function(Blueprint $table) {
			$table->dropForeign('category_variant_template_variant_template_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_product_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_variant_name_id_foreign');
		});
		Schema::table('product_variant_values', function(Blueprint $table) {
			$table->dropForeign('product_variant_values_product_variant_id_foreign');
		});
		Schema::table('product_variant_values', function(Blueprint $table) {
			$table->dropForeign('product_variant_values_variant_value_id_foreign');
		});
		Schema::table('skus', function(Blueprint $table) {
			$table->dropForeign('skus_product_id_foreign');
		});
		Schema::table('product_variant_value_sku', function(Blueprint $table) {
			$table->dropForeign('product_variant_value_sku_product_variant_value_id_foreign');
		});
		Schema::table('product_variant_value_sku', function(Blueprint $table) {
			$table->dropForeign('product_variant_value_sku_sku_id_foreign');
		});
		Schema::table('location_sku', function(Blueprint $table) {
			$table->dropForeign('location_sku_location_id_foreign');
		});
		Schema::table('location_sku', function(Blueprint $table) {
			$table->dropForeign('location_sku_sku_id_foreign');
		});
		Schema::table('sku_images', function(Blueprint $table) {
			$table->dropForeign('sku_images_sku_id_foreign');
		});
		Schema::table('attribute_template_category', function(Blueprint $table) {
			$table->dropForeign('attribute_template_category_attribute_template_id_foreign');
		});
		Schema::table('attribute_template_category', function(Blueprint $table) {
			$table->dropForeign('attribute_template_category_product_type_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_sku_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_location_id_foreign');
		});
		Schema::table('product_attributes', function(Blueprint $table) {
			$table->dropForeign('product_attributes_product_id_foreign');
		});
	}
}