<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'address', 'city_id');

	public function skus()
	{
		return $this->belongsToMany('App\Models\Sku')->withTimestamps()->withPivot('quantity');
	}

	public function transactions()
	{
		return $this->hasMany('App\Models\Transaction');
	}

}