<?php

namespace App\Models;

class ProductVariantValue extends Eloquent {

	protected $table = 'product_variant_values';
	public $timestamps = true;
	protected $fillable = array('product_variant_id', 'variant_value_id', 'sku_template');

	public function productVariant()
	{
		return $this->belongsTo('App\Models\ProductVariant');
	}

	public function skus()
	{
		return $this->belongsToMany('App\Models\Sku')->withTimestamps();
	}

	public function variantValue()
	{
		return $this->belongsTo('App\Models\VariantValue');
	}

}