<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('people', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('person_documents', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('people')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('people')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('employee_contracts', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('people', function(Blueprint $table) {
			$table->dropForeign('people_user_id_foreign');
		});
		Schema::table('person_documents', function(Blueprint $table) {
			$table->dropForeign('person_documents_person_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_user_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_person_id_foreign');
		});
		Schema::table('employee_contracts', function(Blueprint $table) {
			$table->dropForeign('employee_contracts_employee_id_foreign');
		});
	}
}