<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Person extends Eloquent {

	protected $table = 'people';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fist_name', 'last_name', 'fantasy_name', 'type', 'gender', 'birth_date', 'civil_status', 'nationality', 'naturalness', 'mother_name', 'father_name');
	protected $visible = array('fist_name', 'last_name', 'fantasy_name', 'type', 'gender', 'birth_date', 'civil_status', 'nationality', 'naturalness', 'mother_name', 'father_name');

	public function user()
	{
		return $this->belongsTo('Merchant\Entities\User', 'user_id', 'id');
	}

	public function documents()
	{
		return $this->hasMany('Merchant\Entities\PersonDocument');
	}

}