<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractRescissionsTable extends Migration {

	public function up()
	{
		Schema::create('contract_rescissions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->tinyInteger('employee_category')->unsigned();
			$table->char('syndical_code', 15)->nullable();
			$table->char('syndicate_cnpj', 14)->nullable();
			$table->string('syndicate_name', 191)->nullable();
			$table->boolean('was_warned')->default(0);
			$table->date('warning_date');
			$table->date('rescision_date');
			$table->char('rescision_code', 3);
			$table->float('last_salary', 8,2)->default('0');
			$table->float('alimone', 8,2)->nullable();
			$table->float('alimone_on_fgts', 8,2)->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contract_rescissions');
	}
}