<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractSalariesTable extends Migration {

	public function up()
	{
		Schema::create('contract_salaries', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('salary_table_id')->unsigned()->nullable()->index();
			$table->float('value', 8,2);
			$table->boolean('is_commission')->default(0);
			$table->boolean('is_min')->default(0);
			$table->tinyInteger('periodicity_of_payment')->unsigned()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_salaries');
	}
}