<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('category_id')->unsigned()->index();
			$table->string('title', 128);
			$table->string('model', 128);
			$table->json('attributes');
			$table->string('img_url')->nullable();
			$table->text('desc');
			$table->decimal('price');
			$table->integer('quantity')->unsigned();
			$table->enum('status', array(''NotAvailable'', ''Available'', ''ComingSoon''));
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}