<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceTable extends Migration {

	public function up()
	{
		Schema::create('service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('service_time')->nullable();
			$table->string('incall')->nullable();
			$table->string('outcall')->nullable();
			$table->integer('parent_id')->default('0');
			$table->tinyInteger('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('service');
	}
}