<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_last_login', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('added_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('votes', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_reports', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('post_reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('post_reports', function(Blueprint $table) {
			$table->foreign('report_reason_id')->references('id')->on('report_reasons')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('user_last_login', function(Blueprint $table) {
			$table->dropForeign('user_last_login_user_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_added_by_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_post_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('votes', function(Blueprint $table) {
			$table->dropForeign('votes_post_id_foreign');
		});
		Schema::table('post_reports', function(Blueprint $table) {
			$table->dropForeign('post_reports_post_id_foreign');
		});
		Schema::table('post_reports', function(Blueprint $table) {
			$table->dropForeign('post_reports_user_id_foreign');
		});
		Schema::table('post_reports', function(Blueprint $table) {
			$table->dropForeign('post_reports_report_reason_id_foreign');
		});
	}
}